
#version 430 core

layout (location = 0) out vec4 gAlbedoAlpha;

float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}

uniform mat4 VPW;
uniform mat4 worldMatrix;

uniform vec2 centerCoords;

uniform int screenWidth;
uniform int screenHeight;

layout (binding = 0) uniform sampler2D albedoTexture;
layout (binding = 1) uniform sampler2D physicalTexture;

uniform int sampleCount;

uniform float exposure = 0.0024f;
uniform float decay = 1.0f;
uniform float density = 0.50f;
uniform float weight = 5.65f;

void main() {

	vec2 fragCoords = gl_FragCoord.xy / vec2(screenWidth / 2, screenHeight / 2);

	vec4 outputColor;
	vec4 baseColor = texture(albedoTexture, fragCoords);

	vec2 deltaTextCoord = vec2(fragCoords - centerCoords);
	vec2 textCoo = fragCoords;
	deltaTextCoord *= 1.0 /  float(sampleCount) * density;
	float illuminationDecay = 1.0;

	float lightPowerMultiplier = 100.0f / float(sampleCount);

	for(int i=0; i < sampleCount ; i++)
	{
			textCoo -= deltaTextCoord;
			vec4 _sample = texture2D(albedoTexture, textCoo);

			if(_sample.a > 0.1){
				_sample.a = 1.0;			
			}

			_sample *= illuminationDecay * weight;

			outputColor += _sample * lightPowerMultiplier;
			
			illuminationDecay *= decay;
	}
	
	outputColor *= exposure;
	gAlbedoAlpha = outputColor;
}


/*


	vec4 baseAlbedoAlpha = texture(albedoTexture, fragCoords);
	vec4 colorAddition = vec4(0.0);
	vec4 finalColor;

	vec2 fragDirectionalVector = normalize(centerCoords - fragCoords);
	float fragDistance = length(fragCoords - centerCoords);
	float fragDistanceStep = fragDistance / (sampleCount * 2.0);

	if(baseAlbedoAlpha.a != 1.0){

		for(int i = 0; i < sampleCount; i++){
			vec2 sampleCoords = centerCoords + fragDirectionalVector * i * fragDistance;

			colorAddition += texture(albedoTexture, sampleCoords) * pow(0.5, i) * ;

		}

		finalColor = (baseAlbedoAlpha + colorAddition) / 2.0 * (1.0 - fragDistance);

	}else{
	
		finalColor = baseAlbedoAlpha;
	
	}


*/